// GpPenEsc_t.cpp : implementation file
//

#include "stdafx.h"
#include "defsfile.h"
#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CGpPenEsc_t Dialog


CGpPenEsc_t::CGpPenEsc_t(CWnd* pParent /*=NULL*/)
	: CIndecateString(CGpPenEsc_t::IDD, pParent)
{
	//{{AFX_DATA_INIT(CGpPenEsc_t)
	m_cFont = 0;
	m_cFontSize = 0;
	m_iEmphasis = 0;
	m_iDirection = 0;
	m_szString = _T("");
	m_iTurn = 0;
	m_bHalfcentering = FALSE;
	m_bTCP_DECENDER = FALSE;
	m_bTCP_TOP_BOTTOM = FALSE;
	m_cSculpture = 1 ;
	m_iSculBlink = 0;
	//}}AFX_DATA_INIT

	m_bAction = FALSE ;
	Create(IDD,pParent);
}


void CGpPenEsc_t::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CGpPenEsc_t)
	DDX_CBIndex(pDX, IDC_cFont, m_cFont);
	DDX_CBIndex(pDX, IDC_cFontSize, m_cFontSize);
	DDX_CBIndex(pDX, IDC_iEmphasis, m_iEmphasis);
	DDX_CBIndex(pDX, IDC_iDirection, m_iDirection);
	DDX_Text(pDX, IDC_szString, m_szString);
	DDV_MaxChars(pDX, m_szString, 99);
	DDX_CBIndex(pDX, IDC_iTurn, m_iTurn);
	DDX_Check(pDX, IDC_iHalfcentering, m_bHalfcentering);
	DDX_Check(pDX, IDC_TCP_DECENDER, m_bTCP_DECENDER);
	DDX_Check(pDX, IDC_TCP_TOP_BOTTOM, m_bTCP_TOP_BOTTOM);
	DDX_CBIndex(pDX, IDC_cSculpture, m_cSculpture);
	DDX_CBIndex(pDX, IDC_cSculptureBlink, m_iSculBlink);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CGpPenEsc_t, CDialog)
	//{{AFX_MSG_MAP(CGpPenEsc_t)
		// 
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CGpPenEsc_t Message Handler

void CGpPenEsc_t::PostNcDestroy() 
{
	CDialog::PostNcDestroy();
	delete this ;
}


//	Get string size from dialog data
//
//  return FALSE:Error TRUE:OK
BOOL CGpPenEsc_t::GetActionSize()
{
	UpdateData(TRUE);

	if( m_szString.IsEmpty() )
		return FALSE ;

	GPWinGetFontSize(m_szString,m_cFont,m_iTurn,m_iDirection,(( m_cFontSize % 4) << 4 ) | (m_cFontSize / 4) ,(int *)&m_sActionSize.cx,(int *)&m_sActionSize.cy) ;

	return( TRUE );
}


// Create Content
CContents*  CGpPenEsc_t::CreateContents()
{
	// Create empty content
	CContentsEsc_t* pContents = new CContentsEsc_t();

	// Set the data from dialog
	UpdateData(TRUE);
	pContents->m_Data.cDisplayColor = theApp.m_cDisplayColor  ;
	pContents->m_Data.cBackColor = theApp.m_cBackColor  ;

	pContents->m_Data.cFont          = m_cFont ;
	if(m_bTCP_TOP_BOTTOM)
	    pContents->m_Data.cFont |= 0x80 ;

	if( m_bTCP_DECENDER)
    	pContents->m_Data.cFont |= 0x40 ;

	pContents->m_Data.iTurn          = m_iTurn ;
	pContents->m_Data.iDirection     = m_iDirection ;
	pContents->m_Data.iEmphasis      = m_iEmphasis ;
	pContents->m_Data.cSculpture     = (m_iSculBlink << 6) | m_cSculpture ;

	pContents->m_Data.iHalfcentering = (m_bHalfcentering) ? 1 : 0;
	pContents->m_Data.cFontSize		 = (( m_cFontSize % 4) << 4 ) | (m_cFontSize / 4) ;

	strncpy(pContents->m_Data.szString,(LPCTSTR)m_szString,MEMLNK_ESC_T_MAX) ;
	pContents->m_Data.szString[MEMLNK_ESC_T_MAX] = 0 ;


	// Set Content the display position
	pContents->m_Data.iX1 = m_iX1 ;
	pContents->m_Data.iY1 = m_iY1 ;


	return( pContents );
}
